/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.command.api;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_2588;

public final class EnumArgumentType
implements ArgumentType<String> {
    public static final DynamicCommandExceptionType UNKNOWN_VALUE_EXCEPTION = new DynamicCommandExceptionType(o -> new class_2588("quilt.argument.enum.unknown_value", new Object[]{o}));
    private final Set<String> values;
    private static BiMap<Class<? extends Enum<?>>, EnumArgumentType> enumConstantTypes = null;

    public EnumArgumentType(String ... values) {
        this.values = new LinkedHashSet<String>(values.length);
        for (String value : values) {
            String valueLC = value.toLowerCase(Locale.ROOT);
            if (this.values.add(valueLC)) continue;
            throw new IllegalArgumentException("Duplicate value \"%s\" (after converting to lowercase)".formatted(valueLC));
        }
    }

    private EnumArgumentType(Set<String> values) {
        this.values = values;
    }

    public static String getEnum(CommandContext<class_2168> context, String argumentName) {
        return (String)context.getArgument(argumentName, String.class);
    }

    public static <E extends Enum<E>> EnumArgumentType enumConstant(Class<? extends E> enumClass) {
        EnumArgumentType argType = null;
        if (enumConstantTypes == null) {
            enumConstantTypes = HashBiMap.create();
        } else {
            argType = (EnumArgumentType)enumConstantTypes.get(enumClass);
        }
        if (argType == null) {
            Enum[] constants = (Enum[])enumClass.getEnumConstants();
            if (constants == null) {
                throw new IllegalArgumentException("%s is not an enum class (getEnumConstants() returned null)".formatted(enumClass));
            }
            LinkedHashSet<String> values = new LinkedHashSet<String>(constants.length);
            for (Enum constant : constants) {
                String constNameLC = constant.name().toLowerCase(Locale.ROOT);
                if (values.add(constNameLC)) continue;
                throw new IllegalArgumentException("%s contains 2 constants with the same name after converting to lowercase (\"%s\")".formatted(enumClass, constNameLC));
            }
            argType = new EnumArgumentType(values);
            enumConstantTypes.put(enumClass, (Object)argType);
        }
        return argType;
    }

    public static <E extends Enum<E>> E getEnumConstant(CommandContext<class_2168> context, String argumentName, Class<? extends E> enumClass) throws CommandSyntaxException {
        if (enumConstantTypes == null) {
            throw new IllegalArgumentException(enumClass + " does not have an associated EnumArgumentType");
        }
        boolean found = false;
        for (ParsedCommandNode node : context.getNodes()) {
            if (!node.getNode().getName().equals(argumentName)) continue;
            CommandNode argChildNode = node.getNode();
            if (argChildNode instanceof ArgumentCommandNode) {
                ArgumentCommandNode argNode = (ArgumentCommandNode)argChildNode;
                ArgumentType argumentType = argNode.getType();
                if (argumentType instanceof EnumArgumentType) {
                    EnumArgumentType enumConstantType = (EnumArgumentType)argumentType;
                    Class expectedClass = (Class)enumConstantTypes.inverse().get((Object)enumConstantType);
                    if (expectedClass == null) {
                        throw new IllegalArgumentException(argumentName + "'s type does not have an associated enum class");
                    }
                    if (expectedClass != enumClass) {
                        throw new IllegalArgumentException(argumentName + "'s type is derived from  " + expectedClass + ", not from " + enumClass);
                    }
                    found = true;
                    break;
                }
                throw new IllegalArgumentException(argumentName + " is not of EnumArgumentType");
            }
            throw new IllegalArgumentException("Command does not have an argument named " + argumentName);
        }
        if (!found) {
            throw new IllegalStateException("Analysis of command nodes failed to find and check for argument " + argumentName);
        }
        String value = (String)context.getArgument(argumentName, String.class);
        Enum[] constants = (Enum[])enumClass.getEnumConstants();
        if (constants == null) {
            throw new IllegalArgumentException(enumClass + " is not an enum class (getEnumConstants() returned null)");
        }
        for (Enum constant : constants) {
            if (!constant.name().equalsIgnoreCase(value)) continue;
            return (E)constant;
        }
        throw UNKNOWN_VALUE_EXCEPTION.create((Object)argumentName);
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String value = reader.readUnquotedString().toLowerCase(Locale.ROOT);
        if (this.values.contains(value)) {
            return value;
        }
        reader.setCursor(cursor);
        throw UNKNOWN_VALUE_EXCEPTION.createWithContext((ImmutableStringReader)reader, (Object)value);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(this.values, (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return StringArgumentType.StringType.SINGLE_WORD.getExamples();
    }

    public static final class Serializer
    implements class_2314<EnumArgumentType> {
        public void toPacket(EnumArgumentType type, class_2540 buf) {
            buf.method_34062(type.values, class_2540::method_10814);
        }

        public EnumArgumentType fromPacket(class_2540 buf) {
            Set values = (Set)buf.method_34068(LinkedHashSet::new, class_2540::method_19772);
            return new EnumArgumentType(values);
        }

        public void toJson(EnumArgumentType type, JsonObject json) {
            JsonArray valuesArr = new JsonArray();
            for (String value : type.values) {
                valuesArr.add(value);
            }
            json.add("values", (JsonElement)valuesArr);
        }
    }
}

